import { Component, Vue } from 'vue-property-decorator';
import { Getter, Mutation, State } from 'vuex-class';

interface Point {
  h: number;
  i: string;
  moved: boolean;
  w: number;
  x: number;
  y: number;

}

@Component({ name: 'DynamicComponentSort' })
export default class DynamicComponentSort extends Vue {
  @Mutation('SET_CUR_ELE_INDEX') setCurEleIndex;
  @State(state => state.editor.curEleIndex) curEleIndex!: number | null;
  @Getter('pageData') pageData;

  get layout() {
    return this.pageData.elements.map((v, i) => {
      const { point, title, id } = v;
      return {
        point,
        id,
        index: i,
        title: `${title}-${id}`
      };
    }).sort((cur, next) => {
      return cur.point.y > next.point.y ? 1 : -1;
    });
  }
  handleComponentClick(point: Point, index: number) {
    this.$nextTick(() => {
      this.setCurEleIndex(index);
      (document.getElementById('DcmContainerPanel') as HTMLDivElement).scrollTop = point?.y;
    });
  }
}