
import { Application } from 'egg';

export default (application: Application) => {
  const { router, controller } = application;

  const healthMessage = { message: 'service is running...' };
  router.get('/tech/health/check', ctx => {
    ctx.body = healthMessage;
  });

  router.post('/editor/save', controller.editor.save);
  router.post('/editor/update', controller.editor.update);
  router.post('/editor/clearcache', controller.editor.clearCache);
  router.get('/editor/get/list', controller.editor.getList);
  router.get('/editor/get/template', controller.editor.getTemplateList);
  router.get('/editor/getServerTime', controller.editor.getServerTime);
  router.get('/editor/get/:uuid', controller.editor.get);
  router.delete('/editor/:pageId', controller.editor.delete);
  router.get('/editor/login', controller.editor.login);
  router.get('/editor', controller.editor.home);
  router.get('/editor/*', controller.editor.home);

  // 导航配置相关
  router.post('/navigator/save', controller.navigator.saveNavigatorConfig);
  router.get('/navigator/list', controller.navigator.getNavigatorConfigList)
  router.get('/navigator/list/relation', controller.navigator.getNavigatorConfigListWithRelation);
  router.get('/navigator/detail', controller.navigator.getNavigatorDetail);
  router.post('/navigator/delete', controller.navigator.deleteNavigatorConfig)

  router.get('/*', controller.editor.home);
};