const groupColumns = function() {
  return [
    {
      type: 'selection',
      width: 60,
      hideSearch: true
    },
    {
      title: '专题ID',
      key: 'id',
      formType: 'input'
    },
    {
      title: '专题名称',
      key: 'name',
      formType: 'input'
    },
    {
      title: '有效期',
      key: 'validityTime',
      hideSearch: true,
      render: (h, params) => {
        const time = `${params.row.startTime} 至 ${params.row.endTime}`;
        return h('div', time);
      },
    },
    {
      title: '标签',
      key: 'labelName',
      hideSearch: true,
      render: (h, params) => {
        const labelName = [];
        params.row?.listLabel?.forEach(e => {
          labelName.push(e.labelName);
        });
        return h('div', labelName.join(','));
      },
    },
    {
      title: '创建时间',
      key: 'createdAt',
      hideSearch: true,
    }
  ];
};

export default groupColumns;