import {Component, Vue, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide } from 'lodash';
import Upload from '@editor/component/DynamicForm/component/Upload/index.vue';

@Component({ components: { Upload }, name: 'BasicPageForm' })
export default class DynamicForm extends Vue {
  @Getter('pageInfo') pageData;
  @Prop(Boolean) value;

  showPopup: boolean = false;
  formCustom: object = {};
  ruleCustom: object = {
    pageName: [
      { required: true, message: '请输入页面名称', trigger: 'blur' }
    ]
  };

  @Watch('pageData', { immediate: true })
  onPageDataChange(newVal) {
    const { pageName, pageDescribe, coverImage, showDownload, isPublish, isTemplate } = this.pageData;
    this.formCustom = { pageName, pageDescribe, coverImage, showDownload: !!showDownload, isPublish: !!isPublish, isTemplate: !!isTemplate };
  }

  @Watch('value')
  onValueChange(val) {
    console.log('onValueChange', val);
    this.showPopup = val;
  }

  handleSubmit(type) {
    this.$refs.formCustom.validate((valid) => {
      if (valid) {
        this.$emit('submit', type, { ...this.formCustom, showDownload: this.formCustom.showDownload ? 1 : 0, isPublish: this.formCustom.isPublish ? 1 : 0, isTemplate: this.formCustom.isTemplate ? 1 : 0 });
      }
    });
  },
  change(val) {
    this.$emit('input', val);
  }
}