import {Component, Vue, Prop, Watch, Emit} from 'vue-property-decorator';
import DynamicComponent from '@editor/component/DynamicComponent/index.vue';
import { cloneDeep } from 'lodash';
import { basicComponents, businessComponents } from '@lib/config';
import { State } from 'vuex-class';

@Component({ components: { DynamicComponent }, name: 'MaterialMenu' })
export default class DynamicForm extends Vue {
  @State(state => state.editor.templateList) templateList!: any[];

  activeName: string = '1';
  resources: object = { basicComponents, businessComponents };

  // 选择组件库
  selectMaterial(val: string) {
    this.activeName = val;
  }

  @Emit('update:isDraging')
  dragstart() {
    return true;
  }

  @Emit('update:isDraging')
  dragend() {
    return false;
  }

  @Emit('addEle')
  addEle(data) {
    return data;
  }
}