interface Schame {
  key: string;
  name: string;
  type: string;
}

interface Point {
  x: number;
  y: number;
  w: number;
  h: number;
  i: number | string;
  responsive: boolean; // 自定义属性, 表示是否根据背景图片调整宽高
}

interface CommonStyle {
  left?: number;
  top?: number;
  backgroundColor?: string;
  backgroundImage?: string;
}

export interface GridLayout {
  draggable: boolean;
  rowHeight: number;
  colNum: number;
}

export interface PageElement {
  name: string;
  title: string;
  id: string;
  schame: Schame[];
  props: object;
  point: Point;
  commonStyle: CommonStyle;
  child: PageElement[];
}

export interface Page {
  commonStyle: CommonStyle;
  props: object;
  elements: PageElement[];
}

export interface PageInfo {
  id?: number;
  page?: Page | string;
  enable?: number;
  author?: string;
  coverImage?: string;
  shareCoverImage?: string; // 分享缩略图
  shareOpenMethod?: string; // 分享后的打开方式
  isTemplate?: number | boolean;
  isPublish?: number | boolean;
  pageName?: string;
  pageDescribe?: string;
  pageKeywords?: string;
  uuid?: string;
  tenantId?: number;
  diversion?: string;
  redirectUrl?: string;
  validStartTime?: string;
  validEndTime?: string;
}

export default interface EditorState {
  pageInfo: PageInfo;
  curEleIndex: number | null;
  curChildIndex: number | null;
  curRightTabName: string | null;
  templateList: any[];
  gridLayout: GridLayout;
}

export const defaultState = {
  curEleIndex: null,
  curChildIndex: null,
  curRightTabName: null,
  pageInfo: {
    id: 0,
    pageName: '',
    pageDescribe: '',
    pageKeywords: '',
    coverImage: 'http://activitystatic.q-gp.com/low_code.jpg',
    isPublish: false,
    isTemplate: false,
    uuid: '',
    validEndTime: '',
    validStartTime: '',
    redirectUrl: '',
    page: {
      commonStyle: {
        backgroundColor: '#f7f8fa',
        backgroundImage: '',
      },
      props: {
        titleBgColor: '#fff',
        titleUseUrl: false,
        showPageBottomTip: true,
        pageBottomTxt: '没有更多啦～',
        pageBottomColor: '#333',
        showBackTop: true,
        btAttachVal: [
          {
            persets: '购物车',
            name: '购物车',
            icon: 'shopping-cart',
            url: 'xyqb://shoppingCart?needLogin=1',
            color: '#333',
            iconColor: '#333',
            background: '#fff',
            shadow: true,
            radius: true,
            size: 46,
            iconSize: 20
          }
        ],
      },
      elements: [],
      scheme: {}
    }
  },
  templateList: [],
  gridLayout: {
    draggable: true,
    rowHeight: 1,
    colNum: 375
  },
};
