/**
 * @desc 页面信息表
 */
 import { AutoIncrement, Column, DataType, Model, PrimaryKey, Table, AllowNull } from 'sequelize-typescript';

 @Table({
   modelName: 'navigator_config',
   freezeTableName: true
 })
// 初始化sql
//  create table navigator_config (
//   id int(11) primary key auto_increment,
//    name varchar(255) not null comment '页面名称',
//    author varchar(255) not null comment '作者',
//    navigatorData text not null  comment '导航配置数据',
//   `createdAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
//   `updatedAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
// );

 export class NavigatorConfig extends Model<NavigatorConfig> {
 
   @PrimaryKey
   @AutoIncrement
   @Column({
     type: DataType.INTEGER(11)
   })
   id: number;
 
   @Column({
     field: 'name',
     type: DataType.STRING(255)
   })
   name: string;
 
   @Column({
     field: 'author',
     type: DataType.STRING(255)
   })
   author: string;
 
   @Column({
     field: 'navigatorData',
     type: DataType.TEXT
   })
   navigatorData: string;
 
   @Column({
     type: DataType.DATE,
     field: 'updatedAt',
     get() {
       const moment = require('moment');
       const updatedAt = this.getDataValue('updatedAt');
       return moment(updatedAt).format('YYYY-MM-DD HH:mm:ss');
     },
   })
   updatedAt: string;
 }
 
 export default () => NavigatorConfig;