'use strict';
import Vue from 'vue';
import Vuex from 'vuex';
import RootState from './state';
import Editor from './modules/editor';

Vue.use(Vuex);

export default function createStore(initState: any = {}) {
  const { title, url, origin, locale, csrf, editor } = initState;
  console.log('store', title, url, origin, locale, csrf, editor);
  const state = { title, url, origin, locale, csrf };
  return new Vuex.Store<RootState>({
    state,
    modules: {
      editor: new Editor(editor)
    }
  });
}