import { Console } from 'console';
import { Context, Service } from 'egg';
import { result } from 'lodash';

export default class ArticeService extends Service {
  private context: Context;
  constructor(ctx: Context) {
    super(ctx);
    this.context = ctx;
  }
  // 获取导航列表
  async getList(pageNo, pageSize, name = '', author = '') {
    const offset = (+pageNo - 1) * pageSize;;
    const condition = {
      author: null,
      name: null
    };
    // 模糊匹配作者
    if (author) condition.author = author;
    // 模糊匹配名称
    if (name) condition.name = name;
    if (!condition.author) delete condition.author;
    if (!condition.name) delete condition.name;
    const res = await this.context.model.NavigatorConfig
      .findAndCountAll({
        where: condition,
        limit: +pageSize,
        offset
      })
    const result = {
      total: res.count || 0,
      data: res.rows || []
    }  
    return result;
  }
  // 删除导航配置
  async deleteById(id) {
    const res = await this.context.model.NavigatorConfig.destroy({
      where: {
        id
      }
    })
    return res;
  }
  // 保存或编辑
  async saveOrUpdate(data) {
    if (data.id) {
      // 编辑
      const id = data.id;
      const saveData = Object.assign({}, data);
      delete saveData.id;
      const res = await this.context.model.NavigatorConfig.update(saveData, {
        where: {
          id
        }
      })
      return res;
    }
    // 保存
    const res = await this.context.model.NavigatorConfig.create(data);
    return res;
  }
}
