import operationApi from '@api/operation.api';
import { Module, GetterTree, ActionTree, MutationTree } from 'vuex';
import {
  FETCH_AUTH_INFO
} from './type';
import RootState from '../../state';
import EditorAuthInfo from './state';
import Vue from 'vue';

export default class TenantModule implements Module<EditorAuthInfo, RootState> {
  state: EditorAuthInfo;

  getters: GetterTree<EditorAuthInfo, RootState> = {
    authData(state: EditorAuthInfo) {
      return state;
    }
  };

  actions: ActionTree<EditorAuthInfo, RootState> = {
    async fetchTenantAuthData({ commit }) {
      const res: Record<any, any> = await operationApi.getTenantAuthInfo();
      commit(FETCH_AUTH_INFO, JSON.parse(res.authConfig as string));
    }
  };

  mutations: MutationTree<EditorAuthInfo> = {
    [FETCH_AUTH_INFO](state, data) {
      // ! 此处存取存在问题
      Vue.set(this.state, 'tenant', data);
    }
  };

  constructor() {
    this.state = {} as EditorAuthInfo;
  }

}