import { EggAppConfig } from 'egg';
import * as fs from 'fs';
import * as path from 'path';

export default (appInfo: EggAppConfig) => {
  const config: any = {};

  config.siteFile = {
    '/favicon.ico': fs.readFileSync(path.join(appInfo.baseDir, 'app/web/asset/images/favicon.ico'))
  };

  config.view = {
    cache: false
  };

  config.vuessr = {
    layout: path.resolve(appInfo.baseDir, 'app/web/view/layout.html'),
    renderOptions: {
      basedir: path.join(appInfo.baseDir, 'app/view'),
    },
  };

  config.logger = {
    consoleLevel: 'DEBUG',
    dir: path.join(appInfo.baseDir, 'logs')
  };

  config.static = {
    prefix: '/public/',
    dir: path.join(appInfo.baseDir, 'public')
  };

  config.keys = '123456';

  config.middleware = [
    'access'
  ];

  const prodMysqlConfig = {
    dialect: 'mysql',
    username: 'low_code_w',
    password: 'B2pRHuGMLBNybuKp',
    host: 'low-code-db.quantgroups.com',
    port: 3306,
    database: 'low_code',
  };

  const localMysqlConfig = {
    dialect: 'mysql',
    username: 'qa',
    password: 'qatest',
    host: '172.17.5.9',
    port: 31024,
    database: 'low_code',
  };

  console.log('process.env.NODE_ENV', process.env.NODE_ENV);

  exports.sequelize = process.env.NODE_ENV === 'test' ? localMysqlConfig : prodMysqlConfig;

  return config;
};
