'use strict';
const path = require('path');
const SentryPlugin = require("webpack-sentry-plugin");
const resolve = filepath => path.resolve(__dirname, filepath);
const SentryConfig = require("./app/web/.sentryclirc.ts");

module.exports = {
  entry: {
    'login': 'app/web/page/login/index.vue',
    'editor': 'app/web/page/editor/index.ts',
    'activity': 'app/web/page/activity/index.ts',
  },
  resolve: {
    alias:{
      '@': resolve('app/web'),
      '@api': resolve('app/web/api'),
      '@asset': resolve('app/web/asset'),
      '@framework': resolve('app/web/framework'),
      '@component': resolve('app/web/component'),
      '@store': resolve('app/web/page/store'),    
      // '@router': resolve('app/web/page/admin/home/router'),        
      // '@view': resolve('app/web/page/admin/home/view'),
      '@editor': resolve('app/web/page/editor')
    }
  },
  nodeExternals: {
    whitelist: [ moduleName => { 
      if (moduleName.includes('cherry-ui') || moduleName.includes('@interactjs')) {
        console.log(moduleName);
      }
      return /cherry-ui/.test(moduleName) || /@interactjs/.test(moduleName);
    }] 
  },
  module:{
    rules:[
      { babel: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui'), resolve('node_modules/@interactjs')],
          exclude: []
        } 
      },
      {
        vue: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui')],
          exclude: []
        }
      },
      { ts: {
          exclude: []
        } 
      },
      {  less: true },
      { tslint: { options: { fix: true } } },
    ]
  },
  plugins: [
    {
      copy: [{
        from: 'app/web/asset',
        to: 'asset'
      }]
    },
    { imagemini: false },
    {
      sentry: {
        name: 'webpack-sentry-plugin',
        args: SentryConfig
      }
    }
  ],
  devtool:'source-map',
  customize(webpackConfig){
   // 此外 webpackConfig 为原生生成的 webpack config，可以进行自定义处理
   return webpackConfig;
  }
};