import http from '../service/http.service';
import config from '../config';

export default {
  getPageList(params) {
    return http.get('editor/get/list', { params });
  },
  getPageById(params) {
    return http.get(`editor/get/${params.pageId}`);
  },
  delPageById(pageId) {
    return http.delete(`editor/${pageId}`);
  },
  updatePage(params) {
    return http.post(`editor/update`, params);
  },
  savePage(params) {
    return http.post(`editor/save`, params);
  },
  getTemplateList() {
    return http.get('editor/get/template');
  },
};