interface Schame {
  key: string;
  name: string;
  type: string;
}

interface Point {
  x: number;
  y: number;
  w: number;
  moved: boolean;
  h: number;
  i: number | string;
}

interface CommonStyle {
  left: number;
  top: number;
}

interface gridLayout {
  draggable: boolean;
  rowHeight: number;
}

export interface PageElement {
  name: string;
  schame: Schame[];
  props: object;
  point: Point;
  commonStyle: CommonStyle;
  child: PageElement[];
}

export interface Page {
  elements: PageElement[];
}

export interface PageInfo {
  id?: number;
  page?: Page | string;
  enable?: number;
  author?: string;
  coverImage?: string;
  isTemplate?: number;
  isPublish?: number | boolean;
}

export const defaultState = {
  curEleIndex: null,
  curChildIndex: null,
  pageInfo: {
    id: 0,
    pageName: '',
    pageDescribe: '',
    coverImage: 'http://activitystatic.xyqb.com/low_code.jpg',
    isPublish: false,
    page: {
      elements: [],
    }
  },
  templateList: [],
  gridLayout: {
    draggable: true,
    rowHeight: 1
  },
};

export default interface EditorState {
  pageInfo: PageInfo;
  draggable: boolean;
  curEleIndex: number | null;
  curChildIndex: number | null;
  templateList: any[];
  rowHeight: number;
  gridLayout: gridLayout;
}