'use strict';
const path = require('path');
const SentryPlugin = require("webpack-sentry-plugin");
const resolve = filepath => path.resolve(__dirname, filepath);
const SentryConfig = require("./app/web/.sentryclirc.ts");

module.exports = {
  entry: {
    'login': 'app/web/page/login/index.vue',
    'editor': 'app/web/page/editor/index.ts',
    'activity': 'app/web/page/activity/index.ts',
  },
  resolve: {
    alias:{
      '@': resolve('app/web'),
      '@api': resolve('app/web/api'),
      '@asset': resolve('app/web/asset'),
      '@framework': resolve('app/web/framework'),
      '@component': resolve('app/web/component'),
      '@store': resolve('app/web/page/store'),    
      // '@router': resolve('app/web/page/admin/home/router'),        
      // '@view': resolve('app/web/page/admin/home/view'),
      '@editor': resolve('app/web/page/editor')
    }
  },
  nodeExternals: {
    whitelist: [ moduleName => { 
      if (moduleName.includes('cherry-ui') || moduleName.includes('@interactjs')) {
        console.log(moduleName);
      }
      return /cherry-ui/.test(moduleName) || /@interactjs/.test(moduleName);
    }] 
  },
  module:{
    rules:[
      { babel: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui'), resolve('node_modules/@interactjs')],
          exclude: []
        } 
      },
      {
        vue: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui')],
          exclude: []
        }
      },
      { ts: {
          exclude: []
        } 
      },
      {  less: true },
      { tslint: { options: { fix: true } } },
    ]
  },
  plugins: [
    {
      copy: [{
        from: 'app/web/asset',
        to: 'asset'
      }]
    },
    { imagemini: false },
    {
      sentry: {
        env: ['prod'],
        name: 'webpack-sentry-plugin',
        args: SentryConfig
      }
    },
  ],
    optimization: {
    namedModules: true,
    namedChunks: true,
    runtimeChunk: { 
      name: 'runtime' 
    },
    splitChunks:
    {
      name: false,
      chunks: 'all',
      cacheGroups:
      {
        default: false,
        saSdk: {
          name: "chunk-sa-sdk", // split cherryUI into a single package
          priority: 22, // the weight needs to be larger than libs and app or it will be packaged into libs or app
          test: /[\\/]node_modules[\\/]sa-sdk-javascript[\\/]/, // in order to adapt to cnpm
          enforce: true
        },
        cherryUI: {
          name: 'chunk-cherryUI', // 分离组件库
          priority: 21,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]@qg[\\/]cherry-ui[\\/]/,
          enforce: true
        },
        lodash: {
          name: 'chunk-lodash', // 分离组件库
          priority: 19,
          test: /[\\/]node_modules[\\/]lodash[\\/]/,
          enforce: true
        },
        vue: {
          name: 'chunk-vue', // 分离组件库
          priority: 17,
          test: /[\\/]node_modules[\\/]vue[\\/]/,
          enforce: true
        },
        iview: {
          name: 'chunk-iview', // 分离组件库
          priority: 16,
          test: /[\\/]node_modules[\\/]iview[\\/]/,
          enforce: true
        },
        lodash: {
          name: 'chunk-lodash', // 分离组件库
          priority: 15,
          test: /[\\/]node_modules[\\/]lodash[\\/]/,
          enforce: true
        },
        ravenJs: {
          name: 'chunk-ravenJs', // 分离组件库
          priority: 14,
          test: /[\\/]node_modules[\\/]raven-js[\\/]/,
          enforce: true
        },
        common: {
          name:'chunk-common',
          minChunks: 3,
          priority: 3,
          reuseExistingChunk: true,
          chunks (chunk) {
            return ['login','editor','activity'].includes(chunk.name);
          },
          enforce: true
        },
        vendors:
        {
          name: 'common',
          chunks: 'all',
          minChunks: 3,
          priority: 2,
          test: /node_modules/,
          reuseExistingChunk: true
        },
        styles:
        {
          name: 'common',
          chunks: 'all',
          minChunks: 3,
          priority: 1,
          test: /\.(css|less|scss|stylus)$/,
          priority: 50,
        }
      }
    }
  },
  devtool:'source-map',
  customize(webpackConfig){
   // 此外 webpackConfig 为原生生成的 webpack config，可以进行自定义处理
   return webpackConfig;
  }
};