import axios from 'axios';
import basicConfig from '../config';
import localStorage from './localStorage.service';
// import { Notify } from '@qg/cherry-ui';

const ERR_MESSAGE_MAP = {
  status: {
    400: '错误请求',
    401: '未授权，请重新登录',
    403: '拒绝访问',
    404: '请求错误,未找到该资源',
    405: '请求方法未允许',
    408: '请求超时',
    500: '服务器端出错',
    501: '网络未实现',
    502: '网络错误',
    503: '服务不可用',
    504: '网络超时',
    505: 'http版本不支持该请求'
  }
};

const CancelToken = axios.CancelToken;
const pending = {};
const testReq = 0;
let reqNum = 0;
axios.defaults.baseURL = basicConfig.apiHost;
axios.defaults.timeout = 30000;
axios.defaults.xsrfHeaderName = 'x-csrf-token';
axios.defaults.xsrfCookieName = 'csrfToken';

const wait = async seconds => new Promise(resolve => setTimeout(resolve, seconds));

// 体验优化暂时下掉loading
function beforeRequest() {
  reqNum++;
  // store.dispatch("setIsLoading", true);
}

function afterRequest() {
  clearRequest();
  // setTimeout(clearRequest, 300);
}

function clearRequest() {
  reqNum--;
  if (reqNum <= 0) {
    // store.dispatch("setIsLoading", false);
  }
}

const instance = axios.create();

// 请求拦截器
instance.interceptors.request.use(
  config => {
    testReq++;
    console.log('config.url', config.url, testReq, JSON.stringify(pending));
    // beforeRequest();
    // 发起请求时，取消掉当前正在进行的相同请求
    if (pending[config.url as string]) {
      pending[config.url as string]('取消重复请求');
    }
    config.cancelToken = new CancelToken(c => (pending[config.url as string] = c));
    // 添加token
    const token = localStorage.get('Token');
    if (token) {
      config.headers['x-auth-token'] = token;
    }

    return config;
  },
  error => {
    return Promise.reject(error);
  }
);

// 响应拦截器即异常处理
instance.interceptors.response.use(
  response => {
    console.log('response.data.code', JSON.stringify(response && response.data));
    if (response && response.config) {
      let notifyType = 'danger';
      // afterRequest();

      delete pending[response.config.url as string];
      if (response.data.code === '0000' && response.data.businessCode === '0000') { return response.data.data; }

        // 后端返回异常信息时提出警告
      if (response.data.code && response.data.msg) { notifyType = 'warning'; }

        // Notify({
        //   type: notifyType,
        //   message: response.data.msg || '后端服务异常',
        //   duration: notifyType === 'warning' ? 6000 : 3000
        // });
      if (response.data.code === '40100') {
        localStorage.remove('Token');
      }
      return Promise.reject(response.data);
    } else {
      console.log('response.data.code1', JSON.stringify(response));
    }
  },
  async err => {
    console.log('err.response', JSON.stringify(err));
    // afterRequest();
    // 判断是否取消请求
    if (err?.message === '取消重复请求') {
      const res = {
        status: 409,
        data: {}
      };
      return Promise.resolve(res);
    }

    // 提示网络错误时尝试重试
    if (
      err.message === 'Network Error' &&
      (!err.config?.retryCount || err.config?.retryCount <= 3)
    ) {
      if (!err.config?.retryCount) { err.config.retryCount = 1; }
      err.config.retryCount++;
      await wait(3000);
      return axios.request(err.config);
    }

    // 错误提示
    let message = '';
    if (err.response) {
      message = ERR_MESSAGE_MAP.status[err.response.status] || `连接错误${err.response.status}`;
    } else {
      message = '连接到服务器失败';
    }
    // Notify({ type: 'danger', message });
    return Promise.reject(err);
  }
);

export default instance;
