import { kebabCase } from 'lodash';
import { Getter, Action, State, Mutation } from 'vuex-class';
import { Mixins, Component, Watch } from 'vue-property-decorator';
import DynamicComponent from '@editor/component/DynamicComponent/index.vue';
import VueGridLayout from 'vue-grid-layout';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import DynamicForm from '../../component/DynamicForm/index.vue';
import components from '@qg/cherry-ui/src/index.js';
import LoginForm from '@/lib/Form/index.vue';
import { ContextMenu } from '@editor/mixins/contextMenu.mixin';

import BasicPageForm from '@editor/component/BasicPageForm/index.vue';

import { basicComponents, businessComponents } from '@/lib/config';

@Component({components: { DynamicComponent, FreedomContainer, DynamicForm, GridLayout: VueGridLayout.GridLayout,
  GridItem: VueGridLayout.GridItem, LoginForm, BasicPageForm }, name: 'DashBoard'})
export default class DashBoard extends Mixins(ContextMenu) {
  @Mutation('ADD_ELEMENTS') addElements;
  @Mutation('SET_CUR_ELE_INDEX') setCurEleIndex;
  @Mutation('SET_CUR_CHILD_INDEX') setCurChildIndex;
  @Action('resetPageData') resetPageData;
  @Action('savePageData') savePageData;
  @Action('getPageDate') getPageDate;
  @Getter('pageId') pageId;
  @Getter('pageData') pageData;
  @State(state => state.editor.draggable) draggable;
  @State(state => state.editor.curEleIndex) curEleIndex;
  @State(state => state.editor.curChildIndex) curChildIndex;

  activeName: string = '1';
  activeTab: string = '0';
  isCollapsed: boolean = false;
  isDragIn: boolean = false;
  isDraging: boolean = false;
  // curEleIndex: number | null = null;
  // curChildIndex: number | null = null;
  resources: object = { basicComponents, businessComponents };
  showSubmitPopup: boolean = false;
  // todo:
  // 1. grid拖拽进去后的顺序
  // 2. init height

  created() {
    const { pageId } = this.$route.params;
    if (pageId) {
      this.getPageDate({ pageId });
    } else {
      this.resetPageData();
    }
  }

  mounted() {
    this.$nextTick(() => {
      this.activeTab = '2';
    });
    console.log(this.activeTab);
  }

  get layout() {
    return this.pageData.elements.map(v => v.point);
  }

  get curElement() {
    let element = {};
    if (this.curEleIndex !== null) {
      if (this.curChildIndex !== null) {
        element = this.pageData.elements[this.curEleIndex].child[this.curChildIndex];
      } else {
        element = this.pageData.elements[this.curEleIndex];
      }
    }
    return element;
  }

  // 选择组件库
  selectMaterial(val: string) {
    this.activeName = val;
  }

  async save(type, pageConfig) {
    if (!type) {
      this.showSubmitPopup = true;
    } else {
      this.pageData.elements.sort((a, b) => a.point.y - b.point.y);
      const { pageName, pageDescribe, coverImage, showDownload, isPublish } = pageConfig;
      const pageInfo = { page: JSON.stringify(this.pageData), author: 'congmin.hao', isPublish,  pageName, pageDescribe, coverImage, showDownload };
      if (+this.pageId) { pageInfo.id = this.pageId; }
      await this.savePageData(pageInfo);
      this.showSubmitPopup = false;
      if (type === 'preview') {
        window.open(`http://localhost:7001/activity/${this.pageId}`);
      }
    }
  }

  exit() {
    this.$router.back();
  }

  handleElementClick(curEleIndex = null, curChildIndex = null) {
    console.log(curEleIndex, curChildIndex);
    this.toggle(false);
    this.setCurEleIndex(curEleIndex);
    this.setCurChildIndex(curChildIndex);
  }

  toggle(val) {
    this.isCollapsed = val;
  }

  dragstart() {
    this.isDraging = true;
  }

  dragend() {
    this.isDraging = false;
  }

  dragenter() {
    console.log('dragenter');
    this.isDragIn = true;
  }

  dragleave() {
    console.log('dragleave');
    this.isDragIn = false;
  }

  dragover(event) {
    if (event.target.classList.contains('freedom')) {
      event.dataTransfer.dropEffect = 'move';
    } else {
      event.dataTransfer.dropEffect = 'copy';
    }
  }

  modProps(props) {
    console.log('modProps');
    if (this.curEleIndex !== null) {
      if (this.curChildIndex !== null) {
        this.updatePageInfo({ containerIndex: this.curEleIndex, childIndex: this.curChildIndex, data: { ...this.pageData.elements[this.curEleIndex].child[this.curChildIndex], props } });
      } else {
        this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...this.pageData.elements[this.curEleIndex], props } });
      }
    }
  }

  drops(event) {
    console.log(event.target);
    this.isDragIn = false;
    this.isCollapsed = false;
    const data = JSON.parse(event.dataTransfer.getData('text'));
    event.dataTransfer.clearData();
    console.log({...data, i: this.pageData.elements.length}, this.pageData.elements[event.target.dataset.index]);
    if (event.target.classList.contains('freedom')) {
      this.addElements({ containerIndex: event.target.dataset.index, data });
    } else {
      this.addElements({ data: {...data, point: { ...data.point, i: this.pageData.elements.length}} });
    }
  }

  getProps(eleName) {
    const props = {};
    for (const key of Object.keys(components)) {
      const component = components[key];
      if (kebabCase(component.name) === eleName && component.props) {
        console.log(key, component.props);
        for (const prop of Object.keys(component.props)) {
          props[prop] = [Object, Array].includes(component.props[prop].type) ? component.props[prop].default() : component.props[prop].default;
        }
      }
    }

    console.log(props);
    return props;
  }

  resizedEvent(i, h, w) {
    const index = this.pageData.elements.findIndex(ele => ele.point.i === i);
    this.updatePageInfo({ containerIndex: index, data: { ...this.pageData.elements[index], point: { ...this.pageData.elements[index].point, w, h } } });
  }
}