// tslint:disable
import Vue from 'vue';
import { sync } from 'vuex-router-sync';
import App from '@framework/app';
import createStore from '@store/index';
import createRouter from './router/index';
import entry from '@editor/view/home/index.vue';
import './public-path';
Vue.config.devtools = true
const create = function(initState) {
  console.log('initState', initState);
  const store = createStore(initState);
  const router = createRouter();
  sync(store, router);
  return {
    router,
    store,
    render: h => {
      return h(entry);
    },
  };
};

const client = function() {
  const vm = create(window.__INITIAL_STATE__);
  const app = new Vue(vm);
  const root = document.getElementById('app');
  const hydrate = (<HTMLElement>root).childNodes.length > 0;
  app.$mount('#app', hydrate);
};

export async function bootstrap() {}
export async function mount() {
  setTimeout(() => {
    client();
  });
}
export async function unmount() {}

window.__POWERED_BY_QIANKUN__ || mount();
