
import { Application, EggAppConfig } from 'egg';
import apollo from '../app/web/config/apollo.json';

const { mysql, redis } = apollo;

export default (appInfo: EggAppConfig) => {
  const exports: any = {};
  const localMysqlConfig = {
    dialect: 'mysql',
    ...mysql.low_code
  };

  exports.sequelize = localMysqlConfig;

  exports.redis = {
    default: {
      keyPrefix: appInfo.name + ':',
    },
    client: redis
  };
  return exports;
};
