import {Component, Vue } from 'vue-property-decorator';
import { Mutation, Getter } from 'vuex-class';
import { cloneDeep } from 'lodash';

@Component({ name: 'GoodsTabsMixin' })
export default class GoodsTabsMixin extends Vue {
  @Getter('pageData') pageData;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Mutation('COPY_OR_DELETE_PAGE_INFO') updatePageData;
  get hasSearchBarCom() {
    return this.pageData.elements.some(item => item.name === 'cs-search-bar');
  }
  get hasFloorNavCom() {
    return this.pageData.elements.some(item => item.name === 'cs-floor-nav');
  }
  get hasSnapUpCom() {
    return this.pageData.elements.some(item => item.name === 'cs-snap-up');
  }
  get hasSeckillCom() {
    return this.pageData.elements.some(item => item.name === 'cs-seckill');
  }
  get hasGoodsNavCom() {
    return this.pageData.elements.some(item => item.name === 'cs-goods-tabs');
  }
  handleGoodsTabs() {
    const goodsTabs = {};
    const pageData = cloneDeep(this.pageData);
    const hasMoreGoodsTabs = pageData.elements.filter(element => element.name === 'cs-goods-tabs').length > 1;
    pageData.elements.forEach((element, idx) => {
      if (element.name === 'cs-goods-tabs' && element?.props?.list.length) {
        const childs = [];
        const childIndexs = [];
        const idList = element.props.list.map(v => v.componentId);
        if (idList.some(v => !v)) {
          throw new Error('商品导航组件不可为空');
        }
        if (idList.length && idList.length !== Array.from(new Set(idList)).length) {
          throw new Error('商品导航不可重复选择组件');
        }
        element.props.list.forEach((data, index) => {
          const index = pageData.elements.findIndex(v => v.id === data.componentId);
          if (index !== -1) {
            childIndexs.push(index);
            childs.push(pageData.elements[index]);
          }
        });
        goodsTabs[element.id] = { idx, childs, childIndexs };
      }
      if ((this.hasFloorNavCom || hasMoreGoodsTabs) && element.name === 'cs-goods-tabs') {
        element.props.anchor = false;
      }
    });
    let indexs = [];
    Object.keys(goodsTabs).forEach(key => {
      const { idx, childIndexs, childs } = goodsTabs[key];
      pageData.elements[idx].child = childs;
      indexs = [...indexs, ...childIndexs];
    });

    indexs = indexs.sort((a, b) => a - b);
    // 逆向循环
    for (let i = indexs.length - 1; i >= 0; i--) {
      pageData.elements.splice(indexs[i], 1);
    }

    return pageData;
  }

  handleCouponIds(data) {
    const pageData = cloneDeep(data);
     // 下方逻辑: 为一键领取优惠券统计页面所有优惠券组件所含优惠券批次id，并逗号分割，加入到一键领取组件的couponIds字段
    const { elements } = pageData;
    let ids: any = [];
    const batchPickupIndexArr: any[] = []; // 记录一键领取索引值
    elements.forEach((item, index) => {
      console.log(item);
      if (item.name == 'cs-coupon' && item.props.couponsList && item.props.couponsList.length) {
        ids = ids.concat(item.props.couponsList);
      }
      if (item.name == 'cs-batch-pickup') {
        batchPickupIndexArr.push(index);
      }
    });
    ids = Array.from(new Set(ids));
    ids = ids.join();
    if (batchPickupIndexArr.length) {
      for (let i = 0; i < batchPickupIndexArr.length; i++) {
        elements[batchPickupIndexArr[i]].props.couponIds = ids;
      }
    }
    return pageData;
  }

  parseGoodsTabs() {
    const goodsTabs = {};
    this.pageData.elements.forEach((element, idx) => {
      if (element.name === 'cs-goods-tabs' && element?.child?.length) {
        goodsTabs[idx] = cloneDeep(element.child);
        // 逆向循环
        for (let i = element.child.length - 1; i >= 0; i--) {
          this.updatePageData({ type: 'delete', containerIndex: idx, childIndex: i });
        }
      }
    });
    console.log('parseGoodsTabs', goodsTabs);
    Object.keys(goodsTabs).forEach(key => {
      goodsTabs[key].forEach((child, index) => {
        // console.log('parseGoodsTabs', { containerIndex: +key + 1 + index, data: child });
        this.updatePageInfo({ containerIndex: +key + 1 + index, data: child });
      });
    });
  }
  handleTabsRepaetCom() {
    const selectedComponentIds = [];
    this.pageData.elements.forEach(element => {
      if (element.name === 'cs-goods-tabs' || element.name === 'cs-floor-nav') {
        element.props?.list.forEach(item => {
          if (item.componentId && selectedComponentIds.includes(item.componentId)) {
            throw new Error(`组件<${element.title}${element.id}>存在重复组件，请修改后继续操作`);
          } else {
            selectedComponentIds.push(item.componentId);
          }
        });
      }
    });
  }
  handleComAchorScrollEnable() {
    const pageData = cloneDeep(this.pageData);
    pageData.elements.forEach((element, idx) => {
      if (element.name === 'cs-floor-nav') {
        const idList = element.props.list.map(v => v.componentId);
        if (idList.some(v => !v)) {
          throw new Error('楼层导航组件不可为空');
        }
      }
    });
    return pageData;
  }
}
