import {Component, Prop, Watch, Vue} from 'vue-property-decorator';
import TableModal from '../TableModal/index.vue';
import goodsColumn from './columns/goods.column';
import goodsGroupColumn from './columns/goodsGroup.column';
import { cloneDeep } from 'lodash';
import operationApi from '@api/operation.api';

@Component({ components: { TableModal }, name: 'GoodsTableModal' })
export default class GoodsTableModal extends Vue {
  @Prop({ default: () => ({
    type: 'goods',
    ids: []
  }), type: Object }) value;
  @Prop({ default: () => ([]), type: Array }) formControl;

  goods: object = cloneDeep(this.value);
  table: object[] = [
    {
      title: '选择商品',
      type: 'goods',
      key: 'skuNo',
      multiple: true,
      columns: goodsColumn.call(this),
      query: this.query
    },
    {
      title: '选择商品组',
      type: 'goodsGroup',
      key: 'id',
      multiple: false,
      columns: goodsGroupColumn.call(this),
      query: this.queryGroup
    }
  ];

  @Watch('goods')
  onFormChange(newVal) {
    this.$emit('input', newVal);
  }

  async query(data) {
    const { records, total } = await operationApi.skuInfo({ type: 'list', ...data });
    records.forEach(record => {
      if (this.goods.ids.some(v => v === record.skuNo)) {
        record._checked = true;
      }
    });
    return { data: records || [], total };
  },
  async getCategory() {
    function recursionData(data) {
      const list = [];
      data.forEach(item => {
        const { categoryId: id, categoryName: label, categoryLevel: level, children } = item;
        const itemData = { id, label, level };
        if (item.children && item.children.length) { itemData.children = recursionData(children); }
        list.push(itemData);
      });
      return list;
    }

    const res = await operationApi.categoryQuery();
    return recursionData(res.level1List || []);
  },
  async queryGroup(data) {
    const { records, total } = await operationApi.specialPage(data);
    records.forEach(record => {
      if (this.goods.ids.some(v => v === record.skuNo)) {
        record._checked = true;
      }
    });
    return { data: records || [], total };
  }
}