import { Context, Service } from 'egg';

export default class ArticeService extends Service {
  private context: Context;
  constructor(ctx: Context) {
    super(ctx);
    this.context = ctx;
  }

  async set(key, value, seconds = 1000 * 60 * 60 * 24) {
    value = JSON.stringify(value);
    if (this.context.app.redis) {
      await this.context.app.redis.set(key, value, 'EX', seconds);
    }
  }

  async get(key) {
    if (this.context.app.redis) {
      const data = await this.context.app.redis.get(key);
      if (!data) {
        return;
      }
      return JSON.parse(data);
    }
  }

  async del(key) {
    await this.context.app.redis.del(key);
  }
}
