import Vue from 'vue';

import VueRouter from 'vue-router';
import Dashboard from '../view/dashboard/index.vue';
import PageList from '../view/pageList/index.vue';
import myPage from '../view/myPage/index.vue';
import template from '../view/template/index.vue';

Vue.use(VueRouter);

const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};
VueRouter.prototype.replace = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};

export default function createRouter() {
  return new VueRouter({
    mode: 'history',
    base: '/editor/',
    routes: [
      {
        path: '/',
        redirect: 'list'
      },
      {
        name: 'detail',
        path: '/detail/:pageId?',
        component: Dashboard
      },
      {
        name: 'list',
        path: '/list',
        component: PageList
      },
      {
        name: 'my',
        path: '/my',
        component: myPage
      },
      {
        name: 'template',
        path: '/template',
        component: template
      },
    ]
  });
}
