import { kebabCase } from 'lodash';
import { Vue, Component, Watch } from 'vue-property-decorator';
import eleConfig from '../../../editor/utils/config';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import GridLayout from '../../component/VueGridLayout/GridLayout.vue';
import GridItem from '../../component/VueGridLayout/GridItem.vue';
import LoginForm from '@/lib/Form/index.vue';
import DownloadGuide from '@/lib/DownloadGuide/index.vue';

import { Getter, State } from 'vuex-class';

@Component({ components: { FreedomContainer, GridLayout, GridItem, LoginForm, DownloadGuide }, name: 'Activity'})
export default class Activity extends Vue {
  @Getter('pageData') pageData;
  @State(state => state.editor.pageInfo.pageName) pageName;
  @State(state => state.editor.gridLayout.rowHeight) rowHeight;

  isLayoutComReady = false;

  get layout() {
    return this.pageData && this.pageData.elements.map(v => v.point) || [];
  }

  @Watch('pageName')
  onPageNameChange(newVal) {
    if (newVal) {
      document.title = newVal;
      // 如果是 iOS 设备，则使用如下 hack 的写法实现页面标题的更新
      if (navigator.userAgent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/)) {
        const hackIframe = document.createElement('iframe');
        hackIframe.style.display = 'none';
        hackIframe.src = '/public/fixIosTitle.html?r=' + Math.random();
        document.body.appendChild(hackIframe);
        setTimeout(() => {
          document.body.removeChild(hackIframe);
        }, 300);
      }
    }
  }

  fetchApi(options) {
    const { store, route } = options;
    const { pageId } = route.params;
    return store.dispatch('getPageDate', { pageId });
  }

  createStyle({h}) {
    return EASY_ENV_IS_NODE ? {
      height: `${h * 50 + Math.max(0, h - 1) * 10}px`,
    } : {};
  }
}