import { Component, Vue, Prop, Watch } from 'vue-property-decorator';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import { kebabCase, chunk, flatten, cloneDeep } from 'lodash';
import { State } from 'vuex-class';
import { v4 as uuid } from 'uuid';

@Component({ name: 'DynamicComponent' })
export default class DynamicComponent extends Vue {
  @State(state => state.editor.gridLayout.colNum) colNum;
  @State(state => state.tenant.hideFinanceTab) hideFinanceTab;
  @Prop({ default: () => ([]), type: Array }) data;
  @Prop(String) type;

  eleConfig: object[] = [];
  eleConfigMap: object = {};
  activeName: string = '';

  @Watch('hideFinanceTab', { immediate: true })
  onHideFinanceTabChange(val) {
    if (val && this.eleConfigMap.fs) {
      this.$delete(this.eleConfigMap, 'fs');
    }
  }
  @Watch('data', { immediate: true })
  onDataChange(newVal) {
    if (this.type === 'business') {
      this.eleConfigMap = newVal.reduce((pre, cur, index) => {
        if (index === 0) { this.activeName = cur.name; }
        const children = chunk(cur.children, 2);
        pre[cur.name] = { ...cur, children};
        return pre;
      }, {});
    } else {
      this.eleConfig = chunk(newVal, 2);
    }
  }

  dragstart(event, eleName) {
    this.$emit('dragstart');
    const id = uuid().slice(19);
    const { compontObj, page } = this.genrateCom(eleName);
    if (eleName.includes('template')) {
      event.dataTransfer.setData('text', JSON.stringify({
        template: page
      }));
    // 自由容器和商品导航组件有child属性
    } else if (eleName === 'freedom-container' || eleName === 'goods-tabs') {
      event.dataTransfer.setData('text', JSON.stringify({ ...compontObj, child: [] }));
    } else {
      event.dataTransfer.setData('text', JSON.stringify(compontObj));
    }
    event.dataTransfer.effectAllowed = 'copyMove';
  }

  dragend() {
    this.$emit('dragend');
  }

  genrateCom(eleName) {
    const bussinessEleConfig = Object.values(this.eleConfigMap).reduce((pre, cur) => pre.concat(cur.children), []);
    const rawEleConfig = this.type === 'business' ? bussinessEleConfig : this.eleConfig;
    const eleConfig = flatten(rawEleConfig).find(cfg => cfg.eleName === eleName);
    const { title, config, value, commonStyle, page } = cloneDeep(eleConfig);
    const id = uuid().slice(19);
    const pointH = eleName === 'freedom-container' ? 360 : 105;
    return {
      compontObj: {
        id,
        name: eleName,
        title,
        point: {x: 0, y: 0, w: this.colNum, h: pointH, i: id},
        schame: config,
        props: {...value},
        commonStyle
      },
      page
    };
  }

  addEle(eleName) {
    // console.log('addEle', eleName);
    const { compontObj, page } = this.genrateCom(eleName);
    if (eleName.includes('template')) {
      this.$emit('addEle', { template: page });
    } else if (eleName === 'freedom-container' || eleName === 'goods-tabs') {
      this.$emit('addEle', { ...compontObj, child: [] });
    } else {
      this.$emit('addEle', compontObj);
    }
  }

  // getProps(eleName) {
  //   const props = {};
  //   for (const key of Object.keys(components)) {
  //     const component = components[key];
  //     if (kebabCase(component.name) === eleName && component.props) {
  //       for (const prop of Object.keys(component.props)) {
  //         props[prop] = ['Object', 'Array'].includes(component.props[prop].type.name) ? component.props[prop].default && component.props[prop].default() : component.props[prop].default;
  //       }
  //     }
  //   }

  //   return props;
  // }
}