import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide, cloneDeep, assign } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import Upload from '../DynamicForm/component/Upload/index.vue';
import ColorSelector from '../DynamicForm/component/ColorSelector/index.vue';
import BaseSelect from '../DynamicForm/component/BaseSelect/index.vue';
import Textarea from '../DynamicForm/component/Textarea/index.vue';
import Number from '../DynamicForm/component/Number/index.vue';
import { resizeDiv, getStyle } from '@/service/utils.service';

@Component({ components: { Upload, ColorSelector, BaseSelect, Textarea, Number }, name: 'DynamicForm' })
export default class DynamicPageForm extends Mixins(ContextMenuMixin) {
  @Getter('pageData') pageData;

  title: string = '页面';
  commonStyleForm: object = {};
  propsForm: object = {};
  commonStyleSchame: object[] = [
    {
      key: 'backgroundImage',
      name: '背景图片',
      type: 'Upload',
    },
    {
      key: 'backgroundColor',
      name: '背景颜色',
      type: 'ColorSelector'
    }
  ];

  propsSchame: object[] = [
    {
      key: 'showBackTop',
      name: '返回顶部',
      type: 'checkbox'
    }
  ];

  @Watch('pageData', { immediate: true, deep: true })
  onElementChange(newVal) {
    this.commonStyleSchame.forEach(schame => {
      this.$set(this.commonStyleForm, schame.key, this.pageData?.commonStyle[schame.key]);
    });
    this.propsSchame.forEach(schame => {
      this.$set(this.propsForm, schame.key, this.pageData?.props?.[schame.key]);
    });
  }

  @Watch('commonStyleForm', { immediate: true, deep: true })
  onCommonStyleFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'commonStyle');
  }

  @Watch('propsForm', { immediate: true, deep: true })
  onPropsFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'props');
  }

  // resizedChildEvent(type) {
  //   this.$emit('resizedChildEvent', type);
  //   // const containerEle = this.$refs.freedomContainer[this.curEleIndex];
  // }
}