import {Component, Vue } from 'vue-property-decorator';
import { Mutation, Getter } from 'vuex-class';
import { getStyle } from '@/service/utils.service';

@Component({ name: 'ContextMenuMixin' })
export default class ContextMenuMixin extends Vue {
  @Getter('pageData') pageData;
  @Mutation('COPY_OR_DELETE_PAGE_INFO') updatePageData;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Mutation('UPDATE_COMMON_STYLE') updateCommonStyle;

  show(event, containerIndex, childIndex) {
    // console.log('删除', event, containerIndex, childIndex);
    this.$contextmenu({
      items: [
        {
          label: '复制',
          onClick: () => {
            // PERF 可以抽象
            const ComInfo = this.pageData.elements[containerIndex];
            if (ComInfo.name === 'cs-search-bar') {
              this.$Notice.warning({
                title: '搜索框只能添加一个'
              });
              return;
            }
            if (ComInfo.name === 'cs-floor-nav') {
              this.$Notice.warning({
                title: '楼层导航只能添加一个'
              });
              return;
            }
            this.updatePageData({type: 'copy', containerIndex, childIndex});
            // console.log('复制');
          }
        },
        {
          label: '删除',
          onClick: () => {
            // console.log('删除', event, containerIndex, childIndex);
            this.updatePageData({type: 'delete', containerIndex, childIndex});
          }
        },
      ],
      event,
      minWidth: 100
    });
  }

  adjustHeight() {
    if (!this.curEleIndex && this.curEleIndex !== 0) { return; }
    const elements = this.pageData.elements[this.curEleIndex];
    const component = document.getElementById(elements.id);
    if (!component || (component && component.commonStyle.position === 'absolute')) { return; }
    const height = component ? getStyle(component, 'height') : 0;
    const paddingTop = elements.commonStyle.paddingTop || 0;
    const paddingBottom = elements.commonStyle.paddingBottom || 0;
    console.log('adjustHeight', height, elements.commonStyle);
    this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, point: { ...elements.point, h: Math.ceil((+height || elements.point.h) + paddingTop + paddingBottom) } } });
  }
}