# quantum-blocks

基于 Egg + Vue + Webpack SSR 服务端渲染和 CSR 前端渲染工程项目。

Single Page Application Isomorphic Example for Egg + Vue, Front-End and Node of The Application are Written in TypeScript.

## 项目介绍

### 文件路径描述
  * app 主目录
    * controller 解析用户的输入，处理后返回相应的结果
      * editor 页面数据的增删改查
    * service 编写业务逻辑层
      * redis redis服务
    * middleware 编写中间件
      * access 日志中间件
    * extend 框架的扩展
      * helper 辅助函数
    * model sequelize风格的model层
      * pageInfo 页面配置信息表
    * public 放置静态资源
    * web UI层
      * api 接口列表
      * asset 静态资源
      * component 布局组件
        * editor 
          * micro 微前端布局
          * single 单应用布局
        * login 登陆布局
      * config 配置文件
      * framework 初始化目录
      * lib 业务组件库本地配置
      * page 页面
        * editor 低代码入口
          * components 包含公共组件及编辑器右侧表单组件
          * mixin 功能组合
          * router 路由映射
          * view 具体页面
        * login 登陆入口
        * store 状态管理器
      * service 基础服务及公共函数
      * typings 全局类型声明文件
      * views html文件
    * router 配置 URL 路由规则
  * config 编写配置文件
    * config.{env} 编写配置文件
    * plugin 配置需要加载的插件
  * bin 启动目录


## Document

- https://www.yuque.com/easy-team/egg-vue
- https://www.yuque.com/easy-team/easywebpack
- https://easyjs.cn


## QuickStart

- Development

```bash
$ npm install -g easywebpack-cli
$ easy init
$ npm install
$ npm run dev
$ open http://localhost:7001
```

- Publish

```bash
npm run tsc
npm run build
npm start
```

## Features

- ✔︎ Single Page Application, Support Vue Server Side Render and Client Side Render Modes, Rendering Cache, Automatic Downgrade
- ✔︎ Front-End and Node of The Application are Written in TypeScript, Use `vue-property-decorator` and `vuex-class`
- ✔︎ Build with Webpack + TypeScript, Auto Building, Hot Reload, Code Splitting, High Speed, Performance Optimization

## Rendering

- Front-End TypeScript

![Front-End TypeScript](https://github.com/easy-team/egg-vue-typescript-boilerplate/blob/master/docs/images/vue-front-end.png?raw=true)

- Node TypeScript

![Node TypeScript](https://github.com/easy-team/egg-vue-typescript-boilerplate/blob/master/docs/images/vue-node.png?raw=true)

- UI ScreenShot

![UI ScreenShot](https://github.com/easy-team/egg-vue-typescript-boilerplate/blob/master/docs/images/vue-admin-ui.png?raw=true)

## TypeScript

- https://github.com/kaorun343/vue-property-decorator
- https://github.com/ktsn/vuex-class


## License

[MIT](LICENSE)
