import { kebabCase } from 'lodash';
import { Vue, Component } from 'vue-property-decorator';
import eleConfig from '../../../editor/utils/config';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import GridLayout from '../../component/VueGridLayout/GridLayout.vue';
import GridItem from '../../component/VueGridLayout/GridItem.vue';
import LoginForm from '@/lib/Form/index.vue';
import TopBar from '@/component/TopBar';

import {
  Getter
} from 'vuex-class';

@Component({ components: { FreedomContainer, GridLayout, GridItem, TopBar, LoginForm }, name: 'Activity'})
export default class Activity extends Vue {
  @Getter('pageData') pageData;

  isLayoutComReady = false;

  get layout() {
    return this.pageData && this.pageData.elements.map(v => v.point) || [];
  }

  fetchApi(options) {
    const { store, route } = options;
    const { pageId } = route.params;
    return store.dispatch('getPageDate', { pageId });
  }

  createStyle({h}) {
    return EASY_ENV_IS_NODE ? {
      height: `${h * 50 + Math.max(0, h - 1) * 10}px`,
    } : {};
  }
}