import { Component, Prop, Vue } from 'vue-property-decorator';
import LoginForm from '@/lib/Form/index.vue';
import { ContextMenu } from '@editor/mixins/contextMenu.mixin';
import { cloneDeep } from 'lodash';
import { Action, Mutation, State } from 'vuex-class';

@Component({ components: { LoginForm }, name: 'FreedomContainer' })
export default class FreedomContainer extends Vue {
  @Action('setDragable') setDragable;
  @State(state => state.editor.curChildIndex) curChildIndex;

  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop({ type: Boolean, default: true }) showHeader;
  @Prop(String) title;
  @Prop(String) backgroundImage;

  transformStyle(styleObj) {
    const style = {};
    for (const key of Object.keys(styleObj)) {
      style[key] = typeof styleObj[key] !== 'string' ? `${styleObj[key]}px` : styleObj[key];
      if (key === 'backgroundImage') {
        style.backgroundImage = `url(${style.backgroundImage})`;
      }
    }
    return style;
  }
}