import { Controller, Context } from 'egg';
import { trim, omitBy } from 'lodash';

export default class EditorController extends Controller {

  public async home(ctx: Context) {
    await ctx.renderClient('editor.js', {});
  }

  public async save(ctx: Context) {
    const pageInfo = ctx.request.body;
    const result = await ctx.model.PageInfo.create(pageInfo);
    ctx.body = ctx.helper.ok(result);
  }

  public async update(ctx: Context) {
    const pageInfo = ctx.request.body;
    const result = await ctx.model.PageInfo.update(pageInfo, {where: { id: +pageInfo.id }});
    ctx.body = ctx.helper.ok(result);
  }

  public async get(ctx: Context) {
    const pageInfo = await ctx.model.PageInfo.findOne({where: { id: +ctx.params.pageId }});
    ctx.body = ctx.helper.ok(pageInfo);
  }

  public async getList(ctx: Context) {
    const { type, pageSize, pageNo, author, pageName, isPublish } = ctx.query;
    const { like } = ctx.model.Sequelize.Op;
    let where = omitBy({
      author: author && { like: `%${author}%`},
      pageName: pageName && { like: `%${pageName}%`},
      isPublish
    }, v => !trim(v));
    if (type === 'list') {
      where = { ...where, isPublish: 1 };
    } else if (type === 'my') {
      where = { ...where, author: 'congmin.hao' };
    } else if (type === 'template') {
      where = { ...where, isTemplate: 1 };
    }
    const { count: total, rows: data } = await ctx.model.PageInfo.findAndCountAll({ where, limit: +pageSize || 10,
      offset: (+pageNo - 1) * +pageSize || 0 });
    ctx.body = ctx.helper.ok({ total, data });
  }

  public async getTemplateList(ctx: Context) {
    const list = await ctx.model.PageInfo.findAll({ where: { isTemplate: 1 } });
    ctx.body = ctx.helper.ok(list);
  }
}