import { Component, Prop, Mixins } from 'vue-property-decorator';
import LoginForm from '@/lib/Form/index.vue';
import { ContextMenu } from '@editor/mixins/contextMenu.mixin';
import { cloneDeep } from 'lodash';
import { Action, Mutation, State } from 'vuex-class';

@Component({ components: { LoginForm }, name: 'FreedomContainer' })
export default class FreedomContainer extends Mixins(ContextMenu) {
  @Action('setDragable') setDragable;
  @State(state => state.editor.curChildIndex) curChildIndex;

  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop({type: Number, default: 0}) containerIndex;
  @Prop({ type: Boolean, default: false }) showHeader;
  @Prop(String) backgroundImage;

  mousedown(childIndex, event) {
    this.setDragable(false);
    const childItem = cloneDeep(this.childItem);
    const { top: startTop, left: startLeft } = childItem.child[childIndex].commonStyle;
    const { clientY, clientX } = event;

    const move = moveEvent => {
      moveEvent.stopPropagation();
      moveEvent.preventDefault();

      const top = moveEvent.clientY - clientY + startTop;
      const left = moveEvent.clientX - clientX + startLeft;

      this.updatePageInfo({ containerIndex: this.containerIndex, childIndex, data: { ...childItem.child[childIndex], commonStyle: {...childItem.child[childIndex].commonStyle, top, left} } });
    };
    const up = () => {
      this.setDragable(true);
      document.removeEventListener('mousemove', move, true);
      document.removeEventListener('mouseup', up, true);
    };
    document.addEventListener('mousemove', move, true);
    document.addEventListener('mouseup', up, true);
  }

  transformStyle(styleObj) {
    const style = {};
    for (const key of Object.keys(styleObj)) {
      if ( typeof styleObj[key] === 'number') {
        style[key] = `${(styleObj[key] / 37.5).toFixed(2)}rem`;
      } else {
        style[key] = styleObj[key].includes('px') ? `${(+(styleObj[key].slice(0, -2)) / 37.5).toFixed(2)}rem` : styleObj[key];
      }
      if (key === 'backgroundImage') {
        style.backgroundImage = `url(${style.backgroundImage})`;
      }
    }
    return style;
  }

  handleElementClick(curEleIndex, curChildIndex) {
    console.log('handleElementClick', curEleIndex, curChildIndex, this.childItem);
    this.$emit('handleElementClick', curEleIndex, curChildIndex);
  }
}