
const path = require('path');
import { Application, EggAppConfig } from 'egg';

const { mysql, redis, api, qiniu } = require(path.resolve(__dirname, './apollo.json'));
export default (appInfo: EggAppConfig) => {
  const exports: any = {};
  exports.logger = {
    dir: '/home/quant_group/logs',
  };

  exports.sequelize = {
    dialect: 'mysql',
    ...mysql.low_code
  };

  exports.redis = {
    default: {
      keyPrefix: appInfo.name + ':',
    },
    client: redis
  };
  exports.apollo = { ...api, ...qiniu };

  return exports;
};
