
import { Application } from 'egg';

export default (application: Application) => {
  const { router, controller } = application;

  const healthMessage = { message: 'service is running...' };
  router.get('/tech/health/check', ctx => {
    ctx.body = healthMessage;
  });

  router.post('/editor/save', controller.editor.save);
  router.post('/editor/update', controller.editor.update);
  router.get('/editor/get/list', controller.editor.getList);
  router.get('/editor/get/template', controller.editor.getTemplateList);
  router.get('/editor/get/:uuid', controller.editor.get);
  router.delete('/editor/:pageId', controller.editor.delete);
  router.get('/editor/login', controller.editor.login);
  router.get('/editor', controller.editor.home);
  router.get('/editor/*', controller.editor.home);
  router.get('/*', controller.editor.home);
};