import { Subscription } from 'egg';

class clearInvalidPageHistoryRecords extends Subscription {
  // 通过 schedule 属性来设置定时任务的执行间隔等配置
  static get schedule() {
    return {
      cronOptions: {
        tz: 'Asia/Shanghai'
      },
      immediate: false,
      cron: '0 0 2 L * *', // 每月的最后一天凌晨2点整执行
      type: 'all', // 指定所有的 worker 都需要执行
    };
  }
  async subscribe() {
    this.ctx.service.records.clearInvalidPageHistoryRecords();
  }
}

module.exports = clearInvalidPageHistoryRecords;