import { basicComponents, businessComponents } from '@lib/config';

// 获取scheme
export function getAllScheme() {
  let businessComponentsMap = [];
  businessComponents.forEach(item => {
    businessComponentsMap = [...businessComponentsMap, ...item.children];
  });
  const schemeMap = {};
  [...basicComponents, ...businessComponentsMap].forEach(item => {
    schemeMap[item.eleName] = item.config;
  });
  return schemeMap;
}

// 批量移除schema
export function separateAllScheme(elements) {
  elements.forEach(ele => {
    if (ele.schame) {
      delete ele.schame;
    }
    if (ele.child && ele.child.length) {
      separateAllScheme(ele.child);
    }
  });
}

// 提取schame
export function pickAllScheme(elements) {
  const allScheme = getAllScheme();
  let scheme = {};
  elements.forEach(ele => {
    const { name } = ele;
    if (name && !scheme[name]) {
      scheme[name] = allScheme[name];
    }
    if (ele.child && ele.child.length) {
      scheme = Object.assign({}, scheme, pickAllScheme(ele.child));
    }
  });
  return scheme;
}
