import http from '../service/http.service';
import config from '../config';

export default {
  getPageList(params) {
    return http.get('editor/get/list', { params });
  },
  getPageById(params) {
    return http.get(`editor/get/${params.pageId}`);
  },
  delPageById(pageId) {
    return http.delete(`editor/${pageId}`);
  },
  updatePage(params) {
    return http.post(`editor/update`, params);
  },
  savePage(params) {
    return http.post(`editor/save`, params);
  },
  getTemplateList() {
    return http.get('editor/get/template');
  },
  // 商品列表-查询
  skuInfo(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/sku-info/list`, params, {
      accessToken: true
    });
  },
  // 获取商品类目
  categoryQuery() {
    return http.get(`${config.opapiHost}/kdspOp/api/kdsp/op/rear-category/query/all`, {
      accessToken: true
    });
  },
  // 优惠券搜索列表
  couponList(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/op/coupon/list`, params, {
      accessToken: true
    });
  },
  // 商品管理-商品专题列表_分页
  specialPage(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/special/list-page`, params, {
      accessToken: true
    });
  },
  // 商品管理-商品标签列表_分页
  labelPage(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/label-info/list-page`, params, {
      accessToken: true
    });
  },
  // todo: 对外接口需提供x-auth-token
  // 购物车-添加商品
  addShopCart(params) {
    return http.post(`${config.kdspHost}/api/kdsp/shop-cart/add-update`, params, {
      hideToken: true,
      headers: {
        'x-auth-token': '7386386a-3a78-41f9-8584-14933823bf20'
      }
    });
  },
  // 商品组或专题查询
  getGoods(params) {
    return http.post(`${config.kdspHost}/api/kdsp/activity/activity-goods-special/skus`, params, {
      getGoods: true
    });
  },
  // 根据id查询优惠券列表
  getCoupons(params) {
    return http.get(`${config.kdspHost}/api/kdsp/coupon/list`, {
      params,
      hideToken: true,
      headers: {
        'x-auth-token': '7386386a-3a78-41f9-8584-14933823bf20'
      }
    });
  },
  // 领取优惠券
  pickupCoupon(params) {
    return http.post(`${config.kdspHost}/api/kdsp/coupon/pickup`, params, {
      hideToken: true,
      // todo: header里二者参数需特殊处理
      headers: {
        'x-user-terminal': 'H5',
        'vccChannel': '',
        'x-auth-token': ''
      },
    });
  },
  getActivityList(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-info/current-valid-activity`, params, {
      accessToken: true
    });
  },
  // 获取品牌列表
  getBrandAndPriority(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/op/operateIntervene/getBrandAndPriority`, params, {
      accessToken: true
    });
  },
  // 获取品类列表
  getCategoryAndPriority(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/op/operateIntervene/getCategoryAndPriority`, params, {
      accessToken: true
    });
  },
};