# qg-table 查询表单

### 引入

```js
import QGTable from './index.vue';
export default{
  components: {
    QGTable,
  },
}
```

## 代码演示

### 基础用法

`QGTable`需要传入自定义查询条件和表格列

```html
 <QGTable
     :searchCondition="renderSearchCondition"
     :columns="columns"
     :request="query"
     :toolBar="gettoolBar"
    />
```

### 自定义查询条件

通过`searchCondition`属性可以渲染自定义查询条件
每个查询条件包含`lable`、`type`、`key`、`value`、`rules`属性

```html
[
  {label: '状态',type: 'select', key: 'select', option: statusList, value: 1, rules:{required: true, message: '请输入'}},
  {label: '标签',type: 'input', key: 'input', rules: {required:true,trigger: 'blur'}},
  {label: '时间', type: 'date', key:'time'}
],
```

### 表格列

通过`columns`属性控制表格展示的列

```html
columns: [{
  title: '',
  key: ''
}]
```

### 自定义查询操作

通过`request`属性，将改属性是一个方法，默认参数是查询的字端数据，可自定义处理查询的数据，接口处理完毕后需返回表单展示的数据
`data`是表格展示的数据，`total`是分页总数

```html
requestFn(data){
  console.log(data);
  return {
    data: [{},{}],
    total: 100,
 }
},
```

### 自定义按钮

设置`toolBar`控制自定展示按钮

```html
gettoolBar(){
  return [<Button type="primary" onClick={() => this.newElement}>新增</Button>]
},
```

## API

### QGTable Props

| 参数 | 说明 | 类型 | 默认值 |
|------|------|------|------|
| columns | 表格列 | *Array* | `-` |
| request | 查询接口方法 | *Function* | `-` |
| toolBar | 自定义按钮 | *Function* | `-` |

### columns

| 参数 | 说明 | 类型 | 默认值 |
|------|------|------|------|
| title | 条件标题 | *string* | - |
| value | 默认查询值 | *number \| string* | - |
| formType | 表单类型可选值为 `input`、`select`、`date`| *string* | - |
| key | 条件的key | *string* | - |
| rules | 查询条件的校验规则 | *array* | - |
| number | 查询条件的是否为数字 | *boolean* | - |
| valueEnum | 选择框的枚举值 | *object* | - |
| align | 是否居中 | *object* | 'center' |
| hideSearch | 不作为查询条件展示 | *boolean* | false |
| hideTable | 不在列表中展示 | *boolean* | false |
