import { Vue, Component } from 'vue-property-decorator';
import eleConfig from '../../../editor/utils/config';
import FreedomContainer from '../../../editor/component/FreedomContainer/index.vue';
// import schameConfig from '@qg/cherry-ui/src/button/schame.js';
// import components from '@qg/cherry-ui/src/index.js';
import { kebabCase } from 'lodash';
// import {GridLayout, GridItem} from 'vue-grid-layout';
import GridLayout from '../../component/components/GridLayout.vue';
import GridItem from '../../component/components/GridItem.vue';
import LoginForm from '@/lib/Form/index.vue';
import TopBar from '@/component/TopBar';

import {
  Getter
} from 'vuex-class';

@Component({ components: { FreedomContainer, GridLayout, GridItem, TopBar, LoginForm }, name: 'Activity'})
export default class Activity extends Vue {
  @Getter('pageData') pageData;
  // pageData = {elements: [{name: 'cr-field', point: {x: 0, y: 0, w: 12, h: 1, i: '1', moved: false}}, {name: 'cr-button', point: {x: 0, y: 1, w: 12, h: 1, i: '0', moved: false}, schame: [{key: 'color', name: '按钮颜色', type: 'ColorPicker'}, {key: 'text', name: '按钮文案', type: 'Input'}], props: {tag: 'button', type: 'default', size: 'normal', color: '#07c160', text: '按钮1', shape: 'square', nativeType: 'button', loadingSize: '20px'}, commonStyle: {position: 'absolute', top: 5, left: 5}}, {name: 'freedom-container', point: {x: 0, y: 2, w: 12, h: 5, i: '2', moved: false}, child: []}]};

  isLayoutComReady = false;

  get layout() {
    console.log('this.pageData', this.pageData);
    return this.pageData && this.pageData.elements.map(v => v.point) || [];
  }

  fetchApi(options) {
    const { store, route } = options;
    const { pageId } = route.params;
    return store.dispatch('getPageDate', { pageId });
  }

  createStyle({h}) {
    return EASY_ENV_IS_NODE ? {
      height: `${h * 50 + Math.max(0, h - 1) * 10}px`,
      // marginTop: '10px'
    } : {};
  }
}