import { Component, Vue, Prop, Watch } from 'vue-property-decorator';
import components from '@qg/cherry-ui/src/index.js';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import { kebabCase } from 'lodash';
import { chunk, flatten } from 'lodash';

@Component({ name: 'DynamicComponent' })
export default class DynamicComponent extends Vue {
  @Prop({ default: () => ([]), type: Array }) data;

  eleConfig: array = [];

  @Watch('data', { immediate: true })
  onDataChange(newVal) {
    this.eleConfig = chunk(newVal, 2);
  }

  dragstart(event, eleName) {
    this.$emit('dragstart');
    const eleConfig = flatten(this.eleConfig).find(config => config.eleName === eleName);
    const props = this.getProps(eleName);
    if (eleName.includes('template')) {
      event.dataTransfer.setData('text', JSON.stringify({
        template: eleConfig.page
      }));
    } else if (eleName === 'freedom-container') {
      event.dataTransfer.setData('text', JSON.stringify({
        name: eleName,
        point: {x: 0, y: 2, w: 12, h: 5, i: '0'},
        child: [],
        schame: eleConfig.config,
        props: {...props, ...eleConfig.value},
        commonStyle: eleConfig.commonStyle
      }));
    } else {
      event.dataTransfer.setData('text', JSON.stringify({
        name: eleName,
        point: {x: 0, y: 0, w: 12, h: eleConfig.h || 1, i: '0'},
        schame: eleConfig.config,
        props: {...props, ...eleConfig.value},
        commonStyle: eleConfig.commonStyle
      }));
    }
    event.dataTransfer.effectAllowed = 'copyMove';
  }

  dragend() {
    this.$emit('dragend');
    console.log('dragend');
  }

  getProps(eleName) {
    const props = {};
    for (const key of Object.keys(components)) {
      const component = components[key];
      if (kebabCase(component.name) === eleName && component.props) {
        for (const prop of Object.keys(component.props)) {
          props[prop] = ['Object', 'Array'].includes(component.props[prop].type.name) ? component.props[prop].default && component.props[prop].default() : component.props[prop].default;
        }
      }
    }

    console.log(props);
    return props;
  }
}