import { Vue, Component, Prop, Watch } from 'vue-property-decorator';
import iView from 'iview';
import cherryUi from '@qg/cherry-ui';
import VueContextMenu from '@editor/component/Contextmenu/index';
import 'iview/dist/styles/iview.css';
import '@qg/cherry-ui/dist/cherry.css';

Vue.use(iView);
Vue.use(cherryUi);
Vue.use(VueContextMenu);

@Component({
  name: 'Layout',
})
export default class Layout extends Vue {
  activeName: string = 'list';

  get isDashboard() {
    return this.activeName === 'detail';
  }

  @Watch('$route', { immediate: true })
  onRouteChange(to) {
    this.activeName = to.name;
  }

  select(name) {
    this.$router.push({
      name
    });
  }

  created() {
    console.log('>>EASY_ENV_IS_NODE create', EASY_ENV_IS_NODE);
  }
}