import { Component, Vue, Prop, Watch, Emit, Mixins } from 'vue-property-decorator';
import { Getter, Action, State, Mutation } from 'vuex-class';
import type { PageInfo, Page, GridLayout  } from '@store/modules/editor/state';
import TransformStyleMixin from '@page/mixins/transformStyle.mixin';
import FreedomContainer from '@editor/component/FreedomContainer/index.vue';
import PageBottomTip from './component/PageBottomTip/index.vue';
import BackTopPreview from './component/BackTopPreview/index.vue';
import TitlePreview from './component/TitlePreview/index.vue';
@Component({ components: { FreedomContainer, PageBottomTip, BackTopPreview, TitlePreview }, name: 'OperationPanel' })
export default class OperationPanel extends Mixins(TransformStyleMixin) {
  @Getter('pageData') pageData;
  @State(state => state.editor.gridLayout) gridLayout?: GridLayout;
  @State(state => state.editor.curEleIndex) curEleIndex!: number | null;
  @State(state => state.editor.curChildIndex) curChildIndex!: number | null;

  @Prop(Boolean) isDraging;
  @Prop(Boolean) isDragIn;

  bottomInfo: object = {
    x: 0,
    y: 0,
    w: 375,
    h: 60,
    i: 'page-bottom-top'
  };

  get layout() {
    return this.pageData.elements.map(v => v.point);
  }

  // @Watch('layout', { deep: true })
  // onLayoutChange(val) {
  //   const lastGridItemPoint = val[val.length - 1];
  //   if (lastGridItemPoint && lastGridItemPoint.w) {
  //     this.bottomInfo = {
  //       x: 0,
  //       y: 0,
  //       w: 375,
  //       h: 60,
  //       i: 'page-bottom-top'
  //     };
  //     if (lastGridItemPoint.w > this.bottomInfo.w) { this.bottomInfo.w = lastGridItemPoint.w; }
  //     this.bottomInfo.y = this.bottomInfo.y + lastGridItemPoint.y + lastGridItemPoint.h;
  //   }
  // }

  @Emit('update:isDragIn')
  dragenter() {
    return true;
  }

  @Emit('update:isDragIn')
  dragleave() {
    return false;
  }

  @Emit('dragover')
  dragover(event) {
    //
  }

  @Emit('drops')
  drops(event) {
    //
  }

  @Emit('handleElementClick')
  handleElementClick(curEleIndex?: number | null, curChildIndex?: number | null) {
    //
  }

  @Emit('show')
  show(event, containerIndex, childIndex) {
    //
  }

  @Emit('resizedEvent')
  resizedEvent(i, h, w) {
    //
  }

  @Emit('movedEvent')
  movedEvent(i, newX, newY) {
    //
  }

  @Emit('toggle')
  toggle(val) {
    //
  }

  layoutUpdatedEvent() {
    this.$nextTick(() => {
      let layoutSorted = JSON.parse(JSON.stringify(this.layout));
      layoutSorted = layoutSorted.sort((prev, cur) => {
        return cur.y - prev.y;
      });
      const lastGridItemPoint = layoutSorted[0];
      if (lastGridItemPoint && lastGridItemPoint.w) {
        this.bottomInfo = {
          x: 0,
          y: 0,
          w: 375,
          h: 60,
          i: 'page-bottom-top'
        };
        if (lastGridItemPoint.w > this.bottomInfo.w) { this.bottomInfo.w = lastGridItemPoint.w; }
        this.bottomInfo.y = this.bottomInfo.y + lastGridItemPoint.y + lastGridItemPoint.h;
      }
    });
  }
}