export const chunk = function(array, size) {
  const result = [];
  let [start, end] = [null, null];
  for (let i = 0; i < Math.ceil(array.length / size); i++) {
    start = i * size;
    end = start + size;
    result.push(array.slice(start, end));
  }
  return result;
};

export const getParameterByName = function(name, url) {
  if (!url) {
    url = window.location.href;
  }
  name = name.replace(/[\[\]]/g, '\\$&');
  const regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)');
  const results = regex.exec(url);
  if (!results) {
    return null;
  }
  if (!results[2]) {
    return '';
  }
  return decodeURIComponent(results[2].replace(/\+/g, ' '));
};

// 判断输入内容是否为空
export function isNull(str) {
  return str === undefined || str.length === 0 || str === null;
}

// 判断手机号
export function isPhone(str) {
  if (!isNull(str)) {
    const reg = /^1[3456789]\d{9}$/;
    return reg.test(str);
  }
  return false;
}
