#!/usr/bin/env node
const path = require('path');
const apollo = require('@qg/apollo-nodejs');

"use strict";
const npm = require("npm");
(async function() {
  npm.load(() => {
    try {
      await apollo.load({
        appId: 'quantum-blocks',
        configPath: path.resolve(__dirname, '../config'),
      });
    } catch (error) {
      console.log(error);
    }
    
    if (process.env.NODE_ENV === 'production') {
      npm.run("start"); 
    } else {
      npm.run("test");
    }
  });
})();
 