import {Component, Prop, Watch, Vue, Mixins, Emit} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { cloneDeep, uniqBy } from 'lodash';
import Number from '../Number/index.vue';
import QGTable from '@editor/component/QgTable/index.vue';
import { validateType } from '@/service/utils.service';
import operationApi from '@api/operation.api';
import DynamicFormMixin from '../mixins/dynamicForm.mixin';

@Component({ components: { Number, QGTable }, name: 'ComponentSelect' })
export default class DynamicForm extends Mixins(DynamicFormMixin) {
  @State(state => state.editor.curEleIndex) curEleIndex;
  @Getter('pageData') pageData;
  @Prop({ default: () => ([]), type: Array }) formControl;
  @Prop({ default: () => ([]), type: Array }) table;
  @Prop([Object, Array]) value;
  @Prop(String) title;
  @Prop([Object, Array]) templates;

  form: object = {};
  modal: boolean = false;
  selections: object[] = [];
  activeName: number = 0;

  get idsLength() {
    if (validateType(this.value) === 'object') {
      return this.value?.ids?.length;
    }
    return this.value?.length;
  }

  getDefaultIds() {
    if (validateType(this.value) === 'object') {
      return this.value?.ids;
    }
    return this.value;
  }

  @Watch('curEleIndex', { immediate: true })
  onElementChange(newVal) {
    this.formControl.forEach(schame => {
      this.$set(this.form, schame.key, this.pageData.elements[this.curEleIndex].props[schame.key]);
    });
  }

  @Watch('form', { immediate: true, deep: true })
  onFormChange(newVal) {
    // console.log('onFormChange', newVal);
    let parent = this.$parent;
    while (!parent.modProps) {
      parent = parent.$parent;
    }
    parent.modProps(this.form, 'component');
  }

  add() {
    this.modal = true;
  }

  @Emit('update:templates')
  selectionChange(selection) {
    if (!this.table[this.activeName]?.multiple && selection.length > 1) {
      return this.$Notice.warning({
        title: '商品组只能单选'
      });
    }
    this.selections =  uniqBy([...this.selections, ...selection], 'id');
    console.log('selectionChange', this.selections, selection);

    let rs = null;
    if (this.table.length > 1) {
      rs = {
        type: this.table[this.activeName].type,
        ids: this.selections.map(v => v[this.table[this.activeName].key])
      };
    } else {
      rs = this.selections.map(v => v.id);
    }
    return rs;
  }

  selectionCancel(_, row) {
    const index = this.selections.findIndex(v => v.id === row.id);
    this.selections.splice(index, 1);
    console.log('selectionCancel', this.selections, row, index);
  }

  ok() {
    const selections = this.selections.length ? this.selections : this.getDefaultIds();
    // console.log('commit', selections);
    if (this.table.length > 1) {
      this.$emit('input', {
        type: this.table[this.activeName].type,
        ids: selections.map(v => v[this.table[this.activeName].key])
      });
    } else {
      this.$emit('input', selections.map(v => v.id));
    }
  }

  @Emit('update:templates')
  cancel() {
    this.selections = [];

    let rs = null;
    if (this.table.length > 1) {
      rs = {};
    } else {
      rs = [];
    }
    return rs;
  }

  menuChange(name) {
    this.activeName = name;
    this.selections = [];
  }

  editText(type) {
    let rs = '';
    switch (type) {
    case 'edit':
      rs = `编辑${this.title}`;
      break;
    case 'add':
      rs = `添加${this.title}`;
      break;
    case 'choose':
      rs = `选择${this.title}`;
      break;
    }
    return rs;
  }
}