import { EggAppConfig } from 'egg';
import * as fs from 'fs';
import * as path from 'path';
const { mysql, redis, api, qiniu } = require(path.resolve(__dirname, './apollo.json'));
export default (appInfo: EggAppConfig) => {
  const config: any = {};

  config.siteFile = {
  };

  config.view = {
    cache: false
  };

  config.vuessr = {
    layout: path.resolve(appInfo.baseDir, 'app/web/view/layout.html'),
    renderOptions: {
      basedir: path.join(appInfo.baseDir, 'app/view'),
    },
  };

  config.logger = {
    outputJSON: true,
    consoleLevel: 'DEBUG',
    dir: path.join(appInfo.baseDir, 'logs')
  };

  config.static = {
    prefix: '/public/',
    dir: path.join(appInfo.baseDir, 'public')
  };

  config.keys = '123456';

  config.middleware = [
    'access'
  ];

  config.cors = {
    origin: '*',
    allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH'
  };

  config.security = {
    csrf: {
      enable: false
    }
  };

  config.sequelize = {
    dialect: 'mysql',
    ...mysql.low_code
  };

  config.redis = {
    default: {
      keyPrefix: appInfo.name + ':',
    },
    client: redis
  };
  config.apollo = { ...api, ...qiniu };

  return config;
};
