import {Component, Vue, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide } from 'lodash';
import Upload from '@editor/component/DynamicForm/component/Upload/index.vue';
import html2canvas from 'html2canvas';
import editorApi from '@api/editor.api';
import uuidv4 from 'uuid/v4';
import config from '@/config';

@Component({ components: { Upload }, name: 'BasicPageForm' })
export default class DynamicForm extends Vue {
  @Getter('pageInfo') pageData;
  @Prop(Boolean) value;

  showPopup: boolean = false;
  formCustom: object = {};
  ruleCustom: object = {
    pageName: [
      { required: true, message: '请输入页面名称', trigger: 'blur' }
    ]
  };

  @Watch('pageData', { immediate: true })
  onPageDataChange(newVal) {
    const { pageName, pageDescribe, pageKeywords, coverImage, isPublish, isTemplate } = this.pageData;
    this.formCustom = { pageName, pageDescribe, pageKeywords, coverImage, isPublish: !!isPublish, isTemplate: !!isTemplate };
  }

  @Watch('value')
  onValueChange(val) {
    console.log('onValueChange', val);
    this.showPopup = val;
  }

  handleSubmit(type) {
    this.$refs.formCustom.validate(async (valid) => {
      if (valid) {
        await this.createCoverImage();
        this.$emit('submit', type, { ...this.formCustom, isPublish: this.formCustom.isPublish ? 1 : 0, isTemplate: this.formCustom.isTemplate ? 1 : 0 });
      }
    });
  }

  change(val) {
    this.$emit('input', val);
  }

  preview() {
    this.formCustom.pageName = this.formCustom.pageName ?? '未命名';
    this.handleSubmit('preview');
  }

  async createCoverImage() {
    try {
      const imgName = btoa(`coverImage-${uuidv4().substr(0, 8)}`);
      const gridEle = document.querySelector('.Dcm-container-panel');
      const canvas = await html2canvas(gridEle as HTMLElement, { useCORS: true });
      const base64 = canvas.toDataURL();
      const { data: { uptoken } } = await editorApi.getUpToken();
      const { data: { key } } = await editorApi.uploadBase64(base64.split(',')[1], imgName, `UpToken ${uptoken}`);
      this.formCustom.coverImage = config.qiniuHost + key;
    } catch (e) {
      console.log(e);
    }
  }
}