
import { Application, EggAppConfig } from 'egg';
import apollo from './apollo.json';

const { mysql, redis } = apollo;

export default (appInfo: EggAppConfig) => {
  const exports: any = {};
  console.log('>>>env:', process.env.NAMESPACE, process.env.NODE_ENV, process.env.EGG_SERVER_ENV);
  const localMysqlConfig = {
    dialect: 'mysql',
    ...mysql.low_code
  };

  exports.sequelize = localMysqlConfig;

  exports.redis = {
    default: {
      keyPrefix: appInfo.name + ':',
    },
    client: redis
  };
  return exports;
};
