import {Component, Prop, Watch, Vue, Mixins} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { cloneDeep } from 'lodash';
import Number from '../Number/index.vue';
import QGTable from '@editor/component/QgTable/index.vue';
import { validateType } from '@/service/utils.service';
import operationApi from '@api/operation.api';
import DynamicFormMixin from '../mixins/dynamicForm.mixin';

@Component({ components: { Number, QGTable }, name: 'ComponentSelect' })
export default class DynamicForm extends Mixins(DynamicFormMixin) {
  @State(state => state.editor.curEleIndex) curEleIndex;
  @Getter('pageData') pageData;
  @Prop({ default: () => ([]), type: Array }) formControl;
  @Prop({ default: () => ([]), type: Array }) table;
  @Prop([Object, Array]) value;
  @Prop(String) title;

  form: object = {};
  modal: boolean = false;
  selections: object[] = [];
  activeName: number = 0;

  get idsLength() {
    if (validateType(this.value) === 'object') {
      return this.value?.ids?.length;
    }
    return this.value?.length;
  }

  getDefaultIds() {
    if (validateType(this.value) === 'object') {
      return this.value?.ids;
    }
    return this.value;
  }

  @Watch('curEleIndex', { immediate: true })
  onElementChange(newVal) {
    this.formControl.forEach(schame => {
      this.$set(this.form, schame.key, this.pageData.elements[this.curEleIndex].props[schame.key]);
    });
  }

  @Watch('form', { immediate: true, deep: true })
  onFormChange(newVal) {
    console.log('onFormChange', newVal);
    let parent = this.$parent;
    while (!parent.modProps) {
      parent = parent.$parent;
    }
    parent.modProps(this.form, 'component');
  }

  add() {
    this.modal = true;
  }

  selectionChange(selection) {
    if (!this.table[this.activeName]?.multiple && selection.length > 1) {
      return this.$Notice.warning({
        title: '商品组只能单选'
      });
    }
    this.selections = selection;
  }

  ok() {
    const defaultIds = this.getDefaultIds();
    if (this.table.length > 1) {
      this.$emit('input', {
        type: this.table[this.activeName].type,
        ids: this.selections.map(v => v[this.table[this.activeName].key])?.concat(defaultIds);
      });
    } else {
      this.$emit('input', this.selections.map(v => v.id)?.concat(defaultIds));
    }
  }

  cancel() {
    this.selections = [];
  }

  menuChange(name) {
    this.activeName = name;
    this.selections = [];
  }

  editText(type) {
    let rs = '';
    switch (type) {
    case 'edit':
      rs = `编辑${this.title}`;
      break;
    case 'add':
      rs = `添加${this.title}`;
      break;
    case 'choose':
      rs = `选择${this.title}`;
      break;
    }
    return rs;
  }
}