import { getMenuData } from '@api/user.api';
import { Module, GetterTree, ActionTree, MutationTree } from 'vuex';
import {
  FETCH_AUTH_INFO
} from './type';
import RootState from '../../state';
import EditorAuthInfo from './state';
import Vue from 'vue';

export default class TenantModule implements Module<EditorAuthInfo, RootState> {
  state: EditorAuthInfo;

  getters: GetterTree<EditorAuthInfo, RootState> = {
    authData(state: EditorAuthInfo) {
      return state;
    }
  };

  actions: ActionTree<EditorAuthInfo, RootState> = {
    async fetchTenantAuthData({ commit }) {
      const res: Record<any, any> = await getMenuData();
      const authMap: EditorAuthInfo  = {
        financeTab: false
      };
      res.forEach(item => {
        let { uri, code } = item.node;
        uri = uri ? uri : '';
        code = code ? code : '';
        if (uri.indexOf('/template') > -1) {
          authMap.tmplList = true;
        }
        if (uri === '/my') {
          authMap.draftList = true;
        }
        if (uri === '/list') {
          authMap.workist = true;
        }
        if (code === 'cartAndShareBtn') {
          authMap.cartAndShareBtn = true;
        }
        // if (code === 'financeTab') {
        //   authMap.financeTab = true;
        // }
      });
      commit(FETCH_AUTH_INFO, authMap);
    }
  };

  mutations: MutationTree<EditorAuthInfo> = {
    [FETCH_AUTH_INFO](state, data) {
      console.log(this.state.editor.pageInfo.uuid);
      if (!data.cartAndShareBtn && !this.state.editor.pageInfo.uuid) {
        Vue.set(this.state.editor.pageInfo.page.props, 'btAttachVal', []);
      }
      Vue.set(this.state, 'tenant', data);
    }
  };

  constructor() {
    this.state = {} as EditorAuthInfo;
  }

}